//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12

import wesual.Ui 1.0

Item {
    implicitWidth  : icon.implicitWidth  + 6
    implicitHeight : icon.implicitHeight + 6

    UiIcon {
        id : icon

        anchors.centerIn : parent

        iconName : uiToolButton.iconName
        iconSize : uiToolButton.iconSize

        states : [
            State {
                name : "disabled"
                when : !uiToolButton.enabled

                PropertyChanges {
                    target   : icon
                    disabled : 1.0
                }
            },
            State {
                name : "highlight"
                when : uiToolButton.pressed || uiToolButton.down

                PropertyChanges {
                    target    : icon
                    highlight : 1.0
                }
            }
       ]
    }
}
